<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UtilisateurNiveau4 extends Model 
{

    protected $table = 'utilisateurs_niveau4';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'id_entreprise', 'name', 'email', 'telephone', 'role', 'description', 'statut');
    protected $visible = array('slug', 'id_entreprise', 'name', 'email', 'telephone', 'role', 'description', 'statut');

    public function entreprise()
    {
        return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
    }

    public function creanceDetteFond()
    {
        return $this->hasMany('App\Models\CreanceDetteFond', 'id_utilisateurNiveau4');
    }

    public function passageVeterinaire()
    {
        return $this->hasMany('App\Models\PassageVeterinaire', 'id_utilisateurNiveau4');
    }

}